USE [DownloadStatistics]
GO

/****** Object:  StoredProcedure [dbo].[UpdateFileAndProjectCounts]    Script Date: 8/2/2013 10:48:32 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:		<James Davis>
-- Create date: <6/7/2013>
-- Description:	<This sets the TotalDownloads in [dbo].[File], and [dbo].[Project] >
-- =============================================
CREATE PROCEDURE [dbo].[UpdateFileAndProjectCounts] 
AS

declare @rowID BIGINT, @maxID bigint, @tableName varchar(25), @spName varchar(30)
BEGIN
	SET NOCOUNT ON;

	SET @tableName = 'Record';
	SELECT @spName = OBJECT_NAME(@@PROCID);
	SET @rowID = (SELECT TrackedRowID FROM [dbo].[TableAggregateID] WHERE OnTableName = @TableName and ForSproc = @spName);
	SET @maxID = (SELECT MAX(id) FROM [dbo].Record);  -- took off with nolock because if it is uncommited and gets rolled back then it should not be counted

	-- if no last max id used found set to ZERO
	IF(@rowID IS NULL) 
		Begin
		INSERT INTO [dbo].[TableAggregateID](OnTableName, TrackedRowID, ForSproc)  Values(@tableName, 0,@spName);
		SET @rowID = 0;
	END

	;WITH FileCounts (FileID, DownloadCount) AS
	(
	SELECT FileID, COUNT_BIG(FileID) AS DownloadCount
	FROM [dbo].Record
	WHERE ID > @rowID and id <= @maxID
	GROUP BY FileID
	)
	MERGE [dbo].[File] AS TARGET
	USING FileCounts AS SOURCE
	ON (TARGET.ID = SOURCE.FileID)
	WHEN MATCHED THEN
		UPDATE SET TARGET.TotalDownloads = (SOURCE.DownloadCount + TARGET.TotalDownloads),
				TARGET.DateModified = GETUTCDATE();

	-- store last max ID that was used in last run to start from there
	UPDATE TableAggregateID SET TrackedRowID = @maxID where OnTableName = @tableName and ForSproc = @spName;

	;WITH ProjectCounts (ProjectID,TotalDownloadsForProject) AS
	(
		SELECT ProjectID, SUM(TotalDownloads) AS TotalDownloadsForProject
		FROM [dbo].[File] 
		WHERE ProjectID = ProjectID
		GROUP BY ProjectID			
	)
	MERGE [dbo].[Project] AS TARGET
	USING ProjectCounts AS SOURCE
	ON (TARGET.ID = SOURCE.ProjectID)
	WHEN MATCHED and TARGET.TotalDownLoads != SOURCE.TotalDownloadsForProject THEN
		UPDATE SET TARGET.TotalDownLoads = SOURCE.TotalDownloadsForProject + TARGET.HistoricalDownloads,
				TARGET.DateModified = GETUTCDATE();

END

GO


